unit PLOTSpice3_n;

{Copyright (c) 2018, Holger Vogt
All rights reserved.

License: 2-Clause BSD (see DuSpicePlot.lpr)}

{$MODE Delphi}


{******************************************************************
Prepares and initiates SPICE plots
reads input file (*.out), variables may be selected, SPICE will be
called, selected variables transferred as args for plotting

uses special SPICE command exwrite for generating EXCEL compatible
SPICE intermediate output

as an alternative (e.g. for ngspice) converts standard spice raw
file into EXCEL-compatible intermediate format

Copyright Holger Vogt, October 2000
Update juni 2003
Update märz 2015
Update July 2016
Update Jan 2017
Update Feb 2018
*******************************************************************}

interface

uses
    LCLIntf, LCLType, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    Grids, IniFiles, StdCtrls, ExtCtrls, utf8process, ComObj, Clipbrd,
    Variants;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Edit1: TEdit;
    OpenDialog2: TOpenDialog;
    Memo1: TMemo;
    plot_sp_button: TButton;
    QuitButton: TButton;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox20: TCheckBox;
    CheckBox19: TCheckBox;
    CheckBox18: TCheckBox;
    CheckBox17: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox21: TCheckBox;
    CheckBox22: TCheckBox;
    CheckBox23: TCheckBox;
    CheckBox24: TCheckBox;
    CheckBox25: TCheckBox;
    CheckBox26: TCheckBox;
    CheckBox27: TCheckBox;
    CheckBox28: TCheckBox;
    CheckBox29: TCheckBox;
    CheckBox30: TCheckBox;
    CheckBox40: TCheckBox;
    CheckBox39: TCheckBox;
    CheckBox38: TCheckBox;
    CheckBox37: TCheckBox;
    CheckBox36: TCheckBox;
    CheckBox35: TCheckBox;
    CheckBox34: TCheckBox;
    CheckBox33: TCheckBox;
    CheckBox32: TCheckBox;
    CheckBox31: TCheckBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;       // Einträge: alle gespeicherten Variablen
    NeuFile: TButton;
    PrevButton: TButton;
    Cancelbutton: TButton;
    allButton: TButton;
    Memo3: TMemo;
    plot_ex_button: TButton;
    Memo4: TMemo;
    VariableGrid: TStringGrid;
    NextButton: TButton;
    Label2: TLabel;
    ManInCheck: TCheckBox;
    ManInEdit: TEdit;
    DataGrid:  TStringGrid;
    Button1: TButton;

    procedure go(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure QuitButtonClick(Sender: TObject);
    procedure plot_sp_buttonClick(Sender: TObject);
    procedure CancelbuttonClick(Sender: TObject);
    procedure allButtonClick(Sender: TObject);
    procedure NeuFileClick(Sender: TObject);
    procedure plot_ex_buttonClick(Sender: TObject);
    procedure PrevButtonClick(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure quit(Sender: TObject; var Action: TCloseAction);
    procedure plot_gnu_buttonClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Startfile: String;
  PlotFile: String;    // Datei, die geplottet werden soll
  SpiceStartFile: String;
  SpiceFehler: Integer;
  StartIni: TMemIniFile;
  Startpath: String;   // aktueller Pfad des Programms
  PlotFilePath: String; // Pfad des zu plottenden Programms
  FileAlsParam: String;
  AnzahlParam, n, AnzVars, nsets, AktSet: Integer;
  nvars, npoints: Integer; //number of variables and points in original *.out file
  PlotFileStream: TFileStream;
  Flagstr: String; // stores flag
  gridstr: String; // stores grid=3

implementation

// uses applist1;

{$R *.lfm}

{function Graph_Koord(StartX, StartY, EndX, EndY: Integer): String;
// errechnet aus den Koordinaten die Grenzen (Range) der EXCEL-Tabelle
   var
   SX, SY: string;
// ASCII 'A' #65, 'Z' #90
   begin
   StartX := StartX + 64;
   EndX := EndX + 64;
   if StartX <= 90 then
      SX := Char(StartX)
   else if (StartX > 90) and (StartX <= 116)  then
      begin
      StartX := StartX - 26;
      SX := 'A' + Char(StartX);
      end
   else if (StartX > 116) and (StartX <= 142) then
      begin
      StartX := StartX - 52;
      SX := 'B' + Char(StartX);
      end
   else
      SX := 'Fehler';

   SX := SX + IntToStr(StartY);

   if EndX <= 90 then
      SY := Char(EndX)
   else if (EndX > 90) and (EndX <= 116) then
      begin
      EndX := EndX - 26;
      SY := 'A' + Char(EndX);
      end
   else if (EndX > 116) and (EndX <= 142) then
      begin
      EndX := EndX - 52;
      SY := 'B' + Char(EndX);
      end
   else
      SY := 'Fehler';

   SY := SY + IntToStr(EndY);

   result := SX + ':' + SY;
   end;
}

procedure TForm1.FormCreate(Sender: TObject);

begin
  StartPath := ExtractFilePath(ParamStr(0)); // aktuelles Laufwerk z.B. C:\Spice_be/bin
  FileAlsParam := ParamStr(1);
//  PlotArt := ParamStr(2);
  AnzahlParam := ParamCount;
  // Help-File festlegen
  Form1.Helpfile := Startpath + 'DuSpiceHelp.hlp';

// falls Plot über DuSpiceStart aufgerufen, Plotdatei als Parameter übernehmen
  if (AnzahlParam > 0) and (FileAlsParam <> '') then
  begin
     PlotFile := FileAlsParam;
     PlotFilePath := ExtractFilePath(PlotFile);
     Edit1.Text := PlotFile;
  end;
end;


// Funktion aus FMXUtils hier eingebaut, weil zDir als array von 0...79 nicht reicht
function ExecFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  AProcess: TProcessUTF8;
begin
  SetCurrentDir(DefaultDir);
  AProcess := TProcessUTF8.Create(nil);
  AProcess.Executable := FileName;
  AProcess.Parameters.Add(Params);
//  AProcess.Options := AProcess.Options + [poWaitOnExit];
  Result :=  0;
  Try
      AProcess.Execute;
  except
    On E :Exception do begin
      Result := 2;
    end;
  end;
  AProcess.Free;
end;



procedure TForm1.go(Sender: TObject);

var
  Datei1: File;
  m, i: Integer;
  S: String;
  EinZeichen: char;
  Sin: array[0..127] of char;
  Anzchar, m_end: Integer;
  ErrorMsg, tmpstr: String;

begin
  // alle bisher gewählten Parameter löschen
  for m:= 0 to 39 do
  With GroupBox1.Controls[m+4] as TCheckBox do
     begin
        Caption := '';
        Hint := '';
        Enabled := False;
        checked := False;
     end;

  nvars := 0;
  npoints := 0;
  gridstr := '';  

  //Pfad für DuSpice festlegen, in .ini-Datei ablegen
  StartIni := TMemIniFile.Create(Startpath + '\DuSpiceStart.ini');
  SpiceStartFile := StartIni.ReadString('ngspiceExec', 'File' , '');
//  Memo1.Clear;
//  StartIni.ReadSectionValues('ngspiceExec', Memo1.Lines);
//  SpiceStartFile := Memo1.Lines.Values['File'];

  If SpiceStartFile = '' then       // kein File, direkt den Eingabedialog aufrufen
     begin
        OpenDialog2.Title := 'Search for ngspice.exe' ;
        if OpenDialog2.Execute then           {File-Dialogbox öffnen}
           SpiceStartfile := OpenDialog2.FileName      {gewähltes File einlesen}
        else
           begin
              Form1.Close;
              exit;
           end;
        StartIni.WriteString('ngspiceExec', 'File', SpiceStartfile);
     end;
//  StartIni.Free;

// Plotfile suchen
//vorherige Plotdatei einlesen
  if not FileExists(PlotFile) or (PlotFile = '') then
  begin
//     StartIni := TIniFile.Create(Startpath + '\DuSpiceStart.ini');
     Memo1.Clear;
     StartIni.ReadSectionValues('LastPlotFile', Memo1.Lines);
     PlotFile := Memo1.Lines.Values['File'];
 //    StartIni.Free;
     PlotFilePath := ExtractFilePath(PlotFile);

     //im vorherigen Verzeichnis suchen
     OpenDialog1.InitialDir := PlotFilePath;
     OpenDialog1.Title := 'Choose plot file' ;
     OpenDialog1.FileName := PlotFile;

     try
        if OpenDialog1.Execute then           //File-Dialogbox öffnen
        begin
           PlotFile := OpenDialog1.FileName;      //gewähltes File einlesen
           //Test, ob file existiert, falls nicht, Exception
           if not FileExists(PlotFile) then
              raise EInOutError.Create('no file');
           Startfile := ExtractFileName(PlotFile);  //Filename ohne Pfad
           Edit1.Text := PlotFile;
        end
        else
        begin
           Form1.close;   //Schließen, falls Abbruch
           exit;
        end;
     except
        MessageDlg('file ' + PlotFile + ' not found', mtError,
        [mbAbort], 0);
        exit;
     end;
   end;    //vorherige Plotdatei einlesen


   try
      AssignFile(Datei1, PlotFile);
      Reset(Datei1, 1);
      BlockRead(Datei1, EinZeichen, 1, Anzchar);
      if Eof(Datei1)  then  raise EInOutError.Create('file empty');
      CloseFile(Datei1);
   except
      on EFOpenError do
      begin
         if MessageDlg('Could not open ' + StartFile + ',' + #13 + #13 +
         'select new file !', mtError, [mbRetry, mbAbort], 0) = mrRetry then
         begin
            PlotFile := '';      //Rücksetzten, sodaß file-Eingabedialog aufgerufen wird
            go(Sender);
         end;
      Form1.Close;
      end;
      on EInOutError do
      begin
         CloseFile(Datei1);
         if MessageDlg(StartFile  + ': file empty,'+ #13 + #13 +
         'select new file !', mtError, [mbRetry, mbAbort], 0) = mrRetry then
         begin
            PlotFile := '';      //Rücksetzten, sodaß file-Eingabedialog aufgerufen wird
            go(Sender);
            exit;
         end;
         Form1.Close;
      end;

   end;

   // Plotfile öffnen
   try
      PlotFileStream := TFileStream.Create(PlotFile, fmOpenRead);
   except
      PlotFileStream.Free;
      if MessageDlg('Could not open ' + StartFile + ',' + #13 + #13 +
      'select new file !', mtError, [mbRetry, mbAbort], 0) = mrRetry then
      begin
         PlotFile := '';      //Rücksetzten, sodaß file-Eingabedialog aufgerufen wird
         go(Sender);
         exit;
      end;
      Form1.Close;
   end;

   try
// Zeilen einlesen bis 'Variables'
   n := 0;
   nvars := 1;
   repeat
      m := 0;
//    Eine Zeile einlesen
      repeat
         PlotFileStream.Read(Einzeichen, 1);

         Sin[m] := EinZeichen;
         inc(m);    // falls
      until (EinZeichen = #10) or (m > 127);

      Sin[m-1] := #0;
      S := Sin;
      inc(n);
      // Save the file header
      Memo4.Lines.Add(TrimRight(TrimLeft(S)));

      //   Abbruch, falls nach 100 Versuchen, eine Zeile einzulesen,
//   'Variables:' nicht gefunden
      if (n > 100) then
      begin
         ErrorMsg := 'Unknown file format';
         raise EInOutError.Create('Unknown file format');
      end;
//   Anzahl Variablen
      if (copy(S, 0, 14) = 'No. Variables:') then
         nvars := StrToInt(copy(Trim(S), 15, 5));

//   Anzahl Punkte
      if (copy(S, 0, 11) = 'No. Points:') then
      begin
         npoints := StrToInt(copy(Trim(S), 13, 8));
         // add empty line
         Memo4.Lines.Add('');
      end;
// Type of data
      if (copy(S, 0, 6) = 'Flags:') then
      begin
         Flagstr := Trim(copy(S, 7, 127));
         if (SameText(Flagstr,'real') or SameText(Flagstr,'complex')) then
            continue
         else
           begin
             ErrorMsg := 'We handle only real or complex data';
             raise EInOutError.Create('Only real data');
         end
      end;
   until  (Trim(S) = 'Variables:');

// Abbruch, falls keine Daten vorhanden
   if (npoints = 0) then
   begin
      ErrorMsg := 'No data points';
      raise EInOutError.Create('No data points');
   end;

// Anzahl der Parameter-Sets festlegen  (40 Parameter je Set)
   nsets := (nvars div 40) + 1;
   AktSet := 1;                 // aktueller Set

// Buttons festlegen
   if nsets = 1 then
   begin
      PrevButton.Visible := false;
      NextButton.Visible := false;
   end
   else
   begin
      PrevButton.Visible := true;
      NextButton.Visible := true;
      PrevButton.Enabled := false;
      NextButton.Enabled := true;

   end;

      // create grid with rows in chunks of 40
      for i := 1 to nsets * 40 do
      begin
         VariableGrid.InsertColRow(false, i);
      end;
      // alle Variablen bis n einlesen
      AnzVars := 0;

      while (AnzVars < 1000)  do
      begin
         m := 0;
//       Eine Zeile einlesen
         repeat
            PlotFileStream.Read(Einzeichen, 1);
          //  BlockRead(Datei1, EinZeichen, 1, Anzchar);
            Sin[m] := EinZeichen;
            inc(m);    // falls
         until (EinZeichen = #10) or (m > 127);
         Sin[m-1] := #0;
         S := Sin;
         if (Trim(S) = 'Values:') OR
            (Trim(S) = 'Binary:') then break;

         // zweites Wort in S aussuchen, getrennt durch Tabs
         // Name der Variablen
         S := Trim(S);
         Delete(S, 1, Pos(#9, S));
         tmpstr := Copy(S, 0, Pos(#9, S) - 1);
         VariableGrid.Cells[3,AnzVars] := tmpstr;  // for plotting with Spice
         if Flagstr='complex' then      // for plotting with EXCEL
            VariableGrid.Cells[0,AnzVars] := tmpstr + '_re' + #9 + tmpstr + '_im'
         else
            VariableGrid.Cells[0,AnzVars] := tmpstr;

        // drittes Wort in S aussuchen, getrennt durch Tabs
         // Einheit der Variablen
         S := Trim(S);
         Delete(S, 1, Pos(#9, S));
         if Pos('grid', S) > 0 then
         begin
            tmpstr := Copy(S, 0, Pos(' ', S) - 1);
            if Flagstr='complex' then       // for plotting with EXCEL
               VariableGrid.Cells[1,AnzVars] := tmpstr + #9 + tmpstr
            else
               VariableGrid.Cells[1,AnzVars] := tmpstr;
            Delete(S, 1, Pos(' ', S));
            gridstr := #9 + Trim(S) + #9;
         end
         else
         begin
            if Flagstr='complex' then
              VariableGrid.Cells[1,AnzVars] := S + #9 + S
            else
              VariableGrid.Cells[1,AnzVars] := S;
         end;
         VariableGrid.Cells[2,AnzVars] := 'false';
         inc(AnzVars);
//         VariableGrid.InsertColRow(false, AnzVars);
//         VariableGrid.RowCount := AnzVars;
      end;
      PlotFileStream.Free;

   except
//    on EInOutError do
      if MessageDlg(StartFile  + ': ' + ErrorMsg + #13 + #13 +
      'Select new file !', mtError, [mbRetry, mbAbort], 0) = mrRetry then
      begin
         PlotFileStream.Free;
         PlotFile := '';      //Rücksetzten, sodaß file-Eingabedialog aufgerufen wird
         go(Sender);
         exit;
      end;
      Form1.Close;
   end;

      // in .ini-File eintragen
//      StartIni := TIniFile.Create(Startpath + '\DuSpiceStart.ini');
      StartIni.WriteString('LastPlotFile', 'File', PlotFile);
//      StartIni.Free;

      if (AnzVars > 1000) then
      begin
        MessageDlg(IntToStr(nvars) + ' parameters,' + #13 + 'only 1000 will be used!',
          mtWarning, [mbOk], 0);
        AnzVars := 1000;
      end;

      if (AnzVars > 40) then
      begin
         Label2.Visible := true;
         Label2.Caption := 'No. of variables: ' + IntToStr(AnzVars);
      end
      else
         Label2.Visible := false;
// CheckBoxen aktivieren für Set Nr. 1
      if nsets = AktSet then
         m_end := AnzVars - 1  // nur die mit Var. belegten aktivieren
      else
         m_end := 39;          // alle aktivieren
      for m := 0 to  m_end  do
      begin
         // remove the _re ..., if complex
         if Flagstr='complex' then
           S := copy(VariableGrid.Cells[0, m], 0, Pos('_re' + #9, VariableGrid.Cells[0, m]) - 1)
         else
           S := VariableGrid.Cells[0, m];
 //      Start bei Index 4, weil partout die drei Bevels und Label2 in
 //      der dfm-Datei vorne liegen wollen

         With GroupBox1.Controls[m+4] as TCheckBox do
         begin
            Caption := S;
            Hint := S;
            Enabled := True;
            if m = 0 then
               Checked := True
            else
            Checked := False;
         end;
      end;
end;


procedure TForm1.QuitButtonClick(Sender: TObject);
begin
   application.terminate;
end;

procedure TForm1.plot_sp_buttonClick(Sender: TObject);
   // plotten mit SPICE-Befehl 'plot'
   // Eingabefile für SPICE3 aus Memo3 und den gewählten Parametern erstellen
   // Vorgaben sind im Objektinspektor für Memo3 unter 'Lines' festgelegt
var
  m, mstart: Integer;
  S, LoadToSPICE: String;
//  StartParam: String;

begin
   // festlegen, aus welcher Datei zu plotten ist
   // \ gegen / tauschen, " einfügen, damit Dateiname mit Leerzeichen im Pfad
   // als ein Parameter gelesen wird
   LoadToSPICE := '"' + PlotFile + '"';
   while Pos('\', LoadToSPICE) > 0 do
      LoadToSPICE[Pos('\', LoadToSPICE)] := '/';
   Memo3.Lines.Strings[4] := 'load ' + LoadToSPICE;

// Checked Values in VariableGrid abspeichern
   mstart := (AktSet - 1) * 40;
   for m := 0 to 39 do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         if (Checked = True) then
            VariableGrid.Cells[2, m + mstart] := 'true'
         else
            VariableGrid.Cells[2, m + mstart] := 'false';
      end;
   end;

   // festlegen, was zu plotten ist
   S := 'plot ';
   // Start bei m=1, weil m=0 mit 'time' belegt ist
   for m := 1 to  AnzVars  do
      if VariableGrid.Cells[2,m] = 'true' then
         S := S + VariableGrid.Cells[3, m] + ' ';

   Memo3.Lines.Strings[5] := S;     // plot var1, var2 .....

   // add manual command line entries
   if (ManInCheck.Checked = True) and not(TrimRight(ManInEdit.text) = '') then
      begin
      S := S + ManInEdit.text;
      Memo3.Lines.Strings[5] := S;
      end;

   // overwrite 'quit'
   Memo3.Lines.Strings[6] := '';

   // Abbruch, falls nichts gewählt ist
   if (TrimRight(S) = 'plot') then
      begin
         MessageDlg('Nothing to plot !' + #13 + #13 + 'Please choose parameters !',
          mtError, [mbRetry], 0);
         exit;
      end;

   // Eingabefile für Spice3 speichern
   Memo3.Lines.SaveToFile(Startpath + '\SpicPlot_In.inp');

   //Aufruf von Spice3, das als Plot-Ausgabeprogramm genutzt wird
   SpiceFehler := ExecFile(SpiceStartFile ,'SpicPlot_In.inp' , Startpath, SW_SHOW);

   if SpiceFehler = 2 then
      begin
      MessageDlg('ngspice.exe not found !' + #13 + 'Please correct DuSpiceStart.ini !',
        mtError, [mbAbort], 0);
      application.terminate;
      end;

end;

procedure TForm1.CancelbuttonClick(Sender: TObject);
// alle n Parameter nicht auswählen
var
  m, m0: Integer;

begin
  // m=0 nicht löschen
  if AktSet = 1 then
     m0 := 1
  else
     m0 := 0;

  ManInCheck.Checked := False;
  for m := m0 to 39 do
  With GroupBox1.Controls[m+4] as TCheckBox do
     begin
        checked := False;
     end;
end;

procedure TForm1.allButtonClick(Sender: TObject);
// alle n Parameter auswählen
// ist vom gewählten Set AktSet abhängig !
var
  m, mmax: Integer;

begin
  if AktSet = nsets then    // nicht alle 40 Variablen existieren
     mmax := AnzVars - 1 - (AktSet - 1) * 40
  else
     mmax := 39;            // alle 40 Variablen existieren
  ManInCheck.Checked := True;
  for m := 0 to mmax do
     With GroupBox1.Controls[m+4] as TCheckBox do
     begin
        checked := True;
     end;
end;

procedure TForm1.NeuFileClick(Sender: TObject);
var
   m: integer;
begin
  // die ersten 40 bisher gewählten Parameter löschen
  for m:= 0 to 39 do
  With GroupBox1.Controls[m+4] as TCheckBox do
     begin
        Caption := '';
        Hint := '';
        Enabled := False;
        checked := False;
        VariableGrid.Cells[2, m] := 'false';
        VariableGrid.Cells[0, m] := '';
     end;
   PlotFile := '';
   go(Sender);
end;


procedure TForm1.plot_ex_buttonClick(Sender: TObject);

   // Einlesen der Plotdatei *.out
   // Umformatieren der Variablen: Spaltenabschnitte in Zeilen
   // Speichern sp_plot.plt
   // Aufrufen von EXCEL mit Plot_spex2.XLS
   // Sonderbehandlung, falls *.out binary ist.
var
  m, mstart, newvars: Integer;
//  gewaehlt: boolean;
  S, SVar, SUnit, SCount, dez_sep, OutputFile, InputFile, tmpstr: String;
  inpstr, startstring: WideString;
  MSEXCEL: OleVariant;
  EXCELFile, ngOutFile: TextFile;
  I, J: Integer;

begin
   InputFile := 'plot_spex3.xlsm';
   OutputFile := 'sp_plot.plt';

   // Test, dann speichern, welcher Dezimalseparator
   if DefaultFormatSettings.DecimalSeparator = ',' then
      dez_sep := 'komma'
   else if DefaultFormatSettings.DecimalSeparator = '.' then
      dez_sep := 'punkt'
   else
      begin
      MessageDlg('Unknown decimal separator ' + DefaultFormatSettings.DecimalSeparator,
          mtError, [mbAbort], 0);
      exit;
      end;

// Checked Values in VariableGrid abspeichern
   mstart := (AktSet - 1) * 40;
   for m := 0 to 39 do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         if (Checked = True) then
            VariableGrid.Cells[2, m + mstart] := 'true'
         else
            VariableGrid.Cells[2, m + mstart] := 'false';
      end;
   end;

   // Zeile mit gewählten Variablennamen
   SVar := '';
   // Zeile mit zugehöriger Einheit
   SUnit := '';
   newvars := 0;

   for m := 0 to  AnzVars - 1  do
      if VariableGrid.Cells[2,m] = 'true' then
      begin
         SVar := SVar + #9 + VariableGrid.Cells[0, m];
         SUnit := SUnit + #9 + VariableGrid.Cells[1, m];
         SCount := SCount + #9 + IntToStr(newvars);
         inc(newvars);
      end;

   // Abbruch, falls nichts gewählt ist
   if (newvars = 1) then
      begin
         MessageDlg('Nothing to plot !' + #13 + #13 + 'Please choose parameters !',
          mtError, [mbRetry], 0);
         exit;
      end;

   // Open the *out file again

   AssignFile(ngOutFile, PlotFile);
   Reset(ngOutFile);

   try
      AssignFile(EXCELFile, Startpath + '\' + OutputFile);
      Rewrite(EXCELFile);
   except
      MessageDlg('Could not open '+ Startpath + '\' + OutputFile, mtError, [mbAbort], 0);
      Exit;
   end;
   // copy *out to sp_plot.plt until 'No. Variables:' and add actual number
   while not Eof(ngOutFile) do
   begin
      ReadLn(ngOutFile, S);
      if (Copy(S, 0, 14) = 'No. Variables:') then
      begin
         writeln(EXCELFile, 'No. Variables:' + #9 + IntToStr(newvars));
         break;
      end
      else
      begin
      // we need tabs instead of blanks
      //seperate the strings at first occurence of ':'
         tmpstr := copy(S, 0, Pos(':', S));
         S := Trim(copy(S, Pos(':', S) + 1, 127));
         writeln(EXCELFile, tmpstr + #9 + S);
      end;
   end;
   if (npoints > 1048576) then
   begin
      MessageDlg(IntToStr(npoints) + ' data points entered,' + #13
      + 'will be truncated to 1048576 points by EXCEL!',
       mtWarning, [mbOk], 0);
   end;
   ReadLn(ngOutFile, S);
   if (Copy(S, 0, 11) = 'No. Points:') then
   begin
      writeln(EXCELFile, 'No. Points:' + #9 + IntToStr(npoints));
   end;

   while not Eof(ngOutFile) do
   begin
      ReadLn(ngOutFile, S);
      if Trim(S) = 'Variables:' then
      begin
         writeln(EXCELFile, '');
         writeln(EXCELFile, S);
         break;
      end;
      // we need tabs instead of blanks
      //seperate the strings at first occurence of ':'
      tmpstr := copy(S, 0, Pos(':', S));
      S := Trim(copy(S, Pos(':', S) + 1, 127));
      writeln(EXCELFile, tmpstr + #9 + S);
   end;

   while not Eof(ngOutFile) do
   begin
      ReadLn(ngOutFile, S);
      if (S = 'Binary:') then
      // cannot do this right now
      begin
         MessageDlg('Cannot handle binary output files !' + #13 + #13 + 'Please change ngspice plot to ascii !',
          mtError, [mbRetry], 0);
         exit;
      end
      else if (S = 'Values:') then
      begin
         // go on
         break;
      end
      else
         continue;
   end;

   writeln(EXCELFile, SCount);
   writeln(EXCELFile, gridstr);
   writeln(EXCELFile, SUnit);
   writeln(EXCELFile, SVar);

   // column to row of variables
   // by points
   I := 0;
   DataGrid.RowCount := npoints;
   DataGrid.ColCount := 1;
   for J := 0 to npoints - 1 do
   begin
      DataGrid.Cells[0,J] := IntToStr(I) + #9;
      inc(I);
   end;

   for I := 0 to npoints - 1 do
   begin
      for J := 0 to nvars - 1 do
      begin
         ReadLn(ngOutFile, S);
         while S = '' do
            ReadLn(ngOutFile, S);
         if J = 0 then
         begin
            tmpstr :=  copy(S, 0, Pos(#9, S) - 1);
            if ((tmpStr <> '') and (StrToInt(tmpstr) <> I)) then
            begin
               MessageDlg('Error in file ' + PlotFile,
               mtError, [mbCancel], 0);
               exit;
            end;
            S := Trim(copy(S, Pos(#9, S), 127));
         end;
         if VariableGrid.Cells[2,J] = 'true' then
         begin
            if Flagstr='complex' then
            begin
               // replace komma by tab
               S[Pos(',', S)] := #9;
               if dez_sep = 'komma' then    // first komma
                 S[Pos('.', S)] := ',';
            end;
            // convert to dez_sep
            if dez_sep = 'komma' then   // first komma (second if complex
               S[Pos('.', S)] := ',';
            DataGrid.Cells[0,I] := DataGrid.Cells[0,I] + Trim(S) + #9;
         end;
      end;
      // additional empty row
      if Flagstr='complex' then
         ReadLn(ngOutFile, S);
   end;

   for J := 0 to npoints - 1 do
   begin
      writeln(EXCELFile, DataGrid.Cells[0,J]);
   end;

   closefile(EXCELFile);

   try
       // EXCEL aufrufen
      try
         MSExcel := CreateOLEObject('Excel.Application');
      except
         MessageDlg('Could not start Microsoft Excel !', mtError, [mbAbort], 0);
         Exit;
      end;


      try   //EXCEL start
         inpstr := WideString(Startpath + InputFile);
         MSExcel.Workbooks.Open(inpstr);
         MSExcel.Visible := True;
      except
         MessageDlg('Could not start ' + InputFile + '!', mtError, [mbAbort], 0);
        //Exception wieder auslösen, wird in äußere try-Schleife übernommen
         raise;
         exit;
      end;  // try EXECL start

      try
       //   Excel-VBA-Routine aus Modul1 starten
         startstring := WideString(InputFile + '!Modul1.Plot_Start');
         MSExcel.Run(startstring);
         MSExcel.Visible := True;
         MSExcel := UnAssigned;
      except
         exit;
      end;
//     close;

   finally
//   MSExcel.Quit;
      MSExcel := UnAssigned;
//   close;

   end;

end;


procedure TForm1.plot_gnu_buttonClick(Sender: TObject);
   // plotten mit SPICE-Befehl 'gnuplot'
   // Eingabefile für SPICE3 aus Memo3 und den gewählten Parametern erstellen
   // Vorgaben sind im Objektinspektor für Memo3 unter 'Lines' festgelegt
var
  m, mstart: Integer;
  S, LoadToSPICE: String;
//  StartParam: String;

begin
   // festlegen, aus welcher Datei zu plotten ist
   // \ gegen / tauschen, " einfügen, damit Dateiname mit Leerzeichen im Pfad
   // als ein Parameter gelesen wird
   LoadToSPICE := '"' + PlotFile + '"';
   while Pos('\', LoadToSPICE) > 0 do
      LoadToSPICE[Pos('\', LoadToSPICE)] := '/';
   Memo3.Lines.Strings[4] := 'load ' + LoadToSPICE;

// Checked Values in VariableGrid abspeichern
   mstart := (AktSet - 1) * 40;
   for m := 0 to 39 do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         if (Checked = True) then
            VariableGrid.Cells[2, m + mstart] := 'true'
         else
            VariableGrid.Cells[2, m + mstart] := 'false';
      end;
   end;

   // festlegen, was zu plotten ist
   S := 'gnuplot np_gptmp ';
   // Start bei m=1, weil m=0 mit 'time' belegt ist
   for m := 1 to  AnzVars  do
      if VariableGrid.Cells[2,m] = 'true' then
         S := S + VariableGrid.Cells[3, m] + ' ';

   Memo3.Lines.Strings[5] := S;     // gnuplot gptmp var1, var2 .....

   // add manual command line entries
   if (ManInCheck.Checked = True) and not(TrimRight(ManInEdit.text) = '') then
      begin
      S := S + ManInEdit.text;
      Memo3.Lines.Strings[5] := S;
      end;

   // Stop ngspice
   Memo3.Lines.Strings[6] := 'quit';

   // Abbruch, falls nichts gewählt ist
   if (TrimRight(S) = 'gnuplot gptmp') then
      begin
         MessageDlg('Nothing to plot !' + #13 + #13 + 'Please choose parameters !',
          mtError, [mbRetry], 0);
         exit;
      end;

   // Eingabefile für Spice3 speichern
   Memo3.Lines.SaveToFile(Startpath + '\SpicPlot_In.inp');

   //Aufruf von Spice3, das als Plot-Ausgabeprogramm genutzt wird
   SpiceFehler := ExecFile(SpiceStartFile ,'SpicPlot_In.inp' , Startpath, SW_SHOW);

   if SpiceFehler = 2 then
      begin
      MessageDlg('ngspice.exe not found !' + #13 + 'Please correct DuSpiceStart.ini !',
        mtError, [mbAbort], 0);
      application.terminate;
      end;

end;

procedure TForm1.PrevButtonClick(Sender: TObject);
var
   m, mstart: integer;

begin
// Checked Values in VariableGrid abspeichern
   mstart := (AktSet - 1) * 40;
   for m := 0 to 39 do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         if (Checked = True) then
            VariableGrid.Cells[2, m + mstart] := 'true'
         else
            VariableGrid.Cells[2, m + mstart] := 'false';
      end;
   end;
// AktSet setzen
   AktSet := AktSet - 1;
   mstart := (AktSet - 1) * 40;
   NextButton.Enabled := true;
   if AktSet = 1 then
      PrevButton.Enabled := false;
// neuen Set anfahren
// neue Checked Values aus  VariableGrid anzeigen
   for m := 0 to 39 do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         Caption := VariableGrid.Cells[0, m + mstart];
         Hint := VariableGrid.Cells[0, m + mstart];
         Enabled := true;
         if (VariableGrid.Cells[2, m + mstart] = 'true') then
            Checked := true
         else
            Checked := false;
      end;
   end;
end;

procedure TForm1.quit(Sender: TObject; var Action: TCloseAction);
begin
   StartIni.UpdateFile();
   StartIni.Free;
end;

procedure TForm1.NextButtonClick(Sender: TObject);
var
  m, mstart, m_end: integer;
begin
// Checked Values in VariableGrid abspeichern
   mstart := (AktSet - 1) * 40;
   for m := 0 to 39 do 
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         if (Checked = True) then
            VariableGrid.Cells[2, m + mstart] := 'true'
         else
            VariableGrid.Cells[2, m + mstart] := 'false';
      end;
   end;
// AktSet setzen
   AktSet := AktSet + 1;
   mstart := (AktSet - 1) * 40;
   PrevButton.Enabled := true;
   if (AktSet = nsets) then
   begin
      NextButton.Enabled := false;
      m_end := AnzVars -1 - mstart;
   end
   else
      m_end := 39;
// neuen Set anfahren
// neue Checked Values aus  VariableGrid anzeigen
   for m := 0 to m_end do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         Caption := VariableGrid.Cells[0, m + mstart];
         Hint := VariableGrid.Cells[0, m + mstart];
         if (VariableGrid.Cells[2, m + mstart] = 'true') then
            Checked := True
         else
            Checked := false;
      end;
   end;
   for m := m_end + 1 to 39 do
   begin
      With GroupBox1.Controls[m+4] as TCheckBox do
      begin
         Caption := '';
         Hint := '';
         Checked := false;
         Enabled := false;
      end;
   end;


end;

end.
