unit START;
{Copyright (c) 2021, Holger Vogt
All rights reserved.

License: 2-Clause BSD

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
}

{$MODE Delphi}
{$codepage utf8}

interface

uses
    LCLIntf, LCLType, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    StdCtrls, IniFiles, ExtCtrls, Menus, Buttons, ComObj, Ueber, Process,
    utf8process, Setup;

type

  { TForm1 }

  TForm1 = class(TForm)
    Ed_UIF_Button: TButton;
    Debug_Button: TButton;
    out1: TMenuItem;
    debug1: TMenuItem;
    OpenDialog1: TOpenDialog;
    BatchButton: TButton;
    NeuDatButton: TButton;
    AusButton: TButton;
    EditButton: TButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    PlotButton: TButton;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    About1: TMenuItem;
    QuitButton: TBitBtn;
    StartBSPICE1: TMenuItem;
    neueDatei1: TMenuItem;
    Bevel3: TBevel;
    Ende1: TMenuItem;
    Log_Button: TButton;
    Interaktiv_Button: TButton;
    Plot1: TMenuItem;
    logDatei1: TMenuItem;
    log1: TMenuItem;
    OpenDialog2: TOpenDialog;
    StartInteraktiv1: TMenuItem;
    VersionButton: TButton;
    TitleButton: TButton;
    Setup1: TMenuItem;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;


    procedure ComboBox3Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure go(Sender: TObject);
    procedure BatchButtonClick(Sender: TObject);
    procedure log1Click(Sender: TObject);
    procedure LogButtonClick(Sender: TObject);
    procedure NeuDatButtonClick(Sender: TObject);
    procedure AusButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EditButtonClick(Sender: TObject);
    procedure out1Click(Sender: TObject);
    procedure PlotButtonClick(Sender: TObject);
    procedure StartBSPICE1Click(Sender: TObject);
    procedure neueDatei1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Ende1Click(Sender: TObject);
    procedure Hilfe1Click(Sender: TObject);
    procedure DebugButtonClick(Sender: TObject);
    procedure QuitButtonClick(Sender: TObject);
    procedure Interaktiv_ButtonClick(Sender: TObject);
    procedure StartInteraktiv1Click(Sender: TObject);
    procedure UIF(Sender: TObject);
    procedure UpdateStrings;
    procedure UpdateComboBox1;
    procedure ReadRadioButtons;
    procedure TitleButtonClick(Sender: TObject);
    procedure VersionButtonClick(Sender: TObject);
    procedure Setup1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  SpiceStartFile: String;
  StartIni: TIniFile;
  SpiceExName: String;
  SpiceName: String;
  SpiceUIFName: String;
  instatus1, instatus2, instatus3, instatus4: integer;

implementation

//uses applist1;

var

  Editfile: String;
  AusFileName: String;
  CirStartFile: String;    // *.cir
  ViewerStartFile: String;
  EditStartFile: String;
  Cirpath: String;        // Pfad von *.cir
  Startpath: String;      // Pfad von SpiceStart.exe
  DuSpicePath: String;
  ngspicePath: String;

{$R *.lfm}

procedure TForm1.ReadRadioButtons;
begin
try
   instatus1 := StrToInt(StartIni.ReadString('Radiogroups', '1', ''));
   instatus2 := StrToInt(Start.StartIni.ReadString('Radiogroups', '2', ''));
   instatus3 := StrToInt(Start.StartIni.ReadString('Radiogroups', '3', ''));
   instatus4 := StrToInt(Start.StartIni.ReadString('Radiogroups', '4', ''));
except
   instatus1 := 0;
   instatus2 := 0;
   instatus3 := 0;
   instatus4 := 0;
end;
end;

procedure TForm1.go(Sender: TObject);

var
  n, ii: Integer;
  spice_ok: boolean;
  rstring: String;

begin
  spice_ok := false; //xxSpice.exe not available
   // Laufwerk von SPICE_Start
  Startpath := ExtractFilePath(ParamStr(0));
  AusFileName := '';
  // Help-File festlegen
  Form1.Helpfile := Startpath + 'DuSpiceHelp.hlp';
  if (StartIni = nil) then
    StartIni := TMEMIniFile.Create(Startpath + '\DuSpiceStart.ini');

// instatus1: 0: with rawfile              1: w/o rawfile
// instatus2: 0: ngspice                   1: DuSpice
// instatus3: 0: do not start automaticaly 1: start batch mode
//            2: start interactive mode

  //read radiobutton values
  ReadRadioButtons;

  // DuSpice or ngspice
  if (instatus2 = 1) then
  begin
     SpiceExName := 'DuSpice.exe';
     SpiceName := 'DuSpice';
     //Pfad für DuSpice festlegen, aus .ini-Datei lesen
     SpiceStartFile := StartIni.ReadString('DuSpiceExec', 'File', '');
  end
  else
  begin
     SpiceExName := 'ngspice.exe';
     SpiceName := 'ngspice';
     //Pfad für ngspice festlegen, aus .ini-Datei lesen
     SpiceStartFile := StartIni.ReadString('ngspiceExec', 'File', '');
  end;
  //read path and file name for viewer
  ViewerStartFile := StartIni.ReadString('ViewerExec', 'Viewer', '');
  If not FileExists(ViewerStartFile) then
     ViewerStartFile := 'notepad.exe';
//read path and file name for editor
  EditStartFile := StartIni.ReadString('EditExec', 'Editor', '');
  If not FileExists(EditStartFile) then
     EditStartFile := 'notepad.exe';
//read path and file name for user defined initialization file
  SpiceUIFName := StartIni.ReadString('ngspiceUIF', 'File', '');
  If not FileExists(SpiceUIFName) then
     EditStartFile := '.spiceinit';


// check if entry to DuSpiceStart.ini is a file
  if SpiceStartFile <> '' then
  begin
     spice_ok := FileExists(SpiceStartFile) {AND (ExtractFileName(SpiceStartFile) = SpiceExName)}
  end;
  If not spice_ok then
  // kein ini-File: erst ngspice/DuSpice.exe im Pfad von spice_start suchen,
  // falls erfolglos, direkt den Eingabedialog aufrufen
  begin
     OpenDialog2.Title := 'Search for ' + SpiceExName;
     OpenDialog2.FileName := SpiceExName;
     OpenDialog2.InitialDir := 'C:\Spice64\bin\';
     if FileExists('C:\Spice64\bin\' + SpiceExName) then
     begin
        if OpenDialog2.Execute then           {File-Dialogbox öffnen}
        begin
           SpiceStartfile := OpenDialog2.FileName;      {gewähltes File einlesen}
        end
        else
           exit;
     end
     else
     begin
        OpenDialog2.InitialDir := Startpath;
        if OpenDialog2.Execute then           {File-Dialogbox öffnen}
        begin
           SpiceStartfile := OpenDialog2.FileName; {gewähltes File einlesen}
        end;
     end;
     if (instatus2 = 0) then
     {if (SpiceExName = 'ngspice.exe') then}
     begin
        StartIni.WriteString('ngspiceExec', 'File', SpiceStartfile);
        ngspicePath := ExtractFilePath(SpiceStartfile);
     end
     else
     begin
        StartIni.WriteString('DuSpiceExec', 'File', SpiceStartfile);
        DuSpicePath := ExtractFilePath(SpiceStartfile);
     end;
     StartIni.UpdateFile;
   end;
   // Fill in the potential other input files used so far (max 5)
   for ii := 0 to 4 do
   begin
      rstring := StartIni.ReadString('InputFiles', 'File' + IntToStr(ii), '');
      if (rstring = '') then
         break
      else
         ComboBox1.Items.Strings[ii] := rstring;
   end;
  // Test, ob Parameter übergeben wurden (Start über Explorer mit Eingabedatei)
   if ParamCount > 0 then
   begin
      CirStartFile := ParamStr(1);
      // Parameter aufsummieren mit Leerzeichen, falls Pfadname Leerzeichen enthält
      for n := 2 to ParamCount do
         CirStartFile :=   CirStartFile + ' ' + ParamStr(n);
      ComboBox1.Text := CirStartFile ;
      // Programm starten
      BatchButton.Click;
   end
   else
   // Start ohne Parameterübergabe
   begin
      CirStartFile := StartIni.ReadString('LastInputFile', 'File', '');
      If CirStartFile = '' then
      begin
         NeuDatButton.Click;   // kein File, direkt den Eingabedialog aufrufen
      end;
      ComboBox1.Text := CirStartFile ;
   end;
   CirPath := ExtractFilePath(CirStartFile);
   //  Form1.HelpFile := Startpath + '\DuSpiceHelp.hlp';
   Interaktiv_Button.hint := 'start ' + SpiceName + ' in interactive mode';
   if (instatus1 = 0) then
      BatchButton.hint := 'start ' + SpiceName + ' in batch mode with rawfile'
   else
      BatchButton.hint := 'start ' + SpiceName + ' in batch mode w/o rawfile';
   if (instatus1 = 0) then
      NeuDatButton.Hint := 'select new input file, do not start'
   else if (instatus1 = 1) then
      NeuDatButton.Hint := 'select new input file and start batch mode'
   else
      NeuDatButton.Hint := 'select new input file and start interactive mode';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin

end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin

end;

function SlashToSlash(Input: String): String;
     //  \ gegen / tauschen
begin
   while Pos('\', Input) > 0 do
      Input[Pos('\', Input)] := '/';
   Result := Input;
end;


// Funktion aus FMXUtils hier eingebaut, weil zDir als array von 0...79 nicht reicht
function ExecFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  AProcess: TProcessUTF8;
begin
  SetCurrentDir(DefaultDir);
  AProcess := TProcessUTF8.Create(nil);
  AProcess.Executable := FileName;
  AProcess.Parameters.Add(Params);
//  AProcess.Options := AProcess.Options + [poWaitOnExit];
  Result :=  0;
  Try
      AProcess.Execute;
  except
    On E :Exception do begin
      Result := 2;
    end;
  end;
  AProcess.Free;
end;


// Funktion aus FMXUtils hier eingebaut, weil zDir als array von 0...79 nicht reicht
function ExecFile2(const FileName, DefaultDir: string; ilist: TStringList): THandle;
var
  AProcess: TProcessUTF8;
  I: integer;
begin
  SetCurrentDir(DefaultDir);
  AProcess := TProcessUTF8.Create(nil);
  AProcess.Executable := FileName;
  for I := 0 to ilist.Count - 1 do
  begin;
      AProcess.Parameters.Add(ilist.Strings[I]);
  end;
//  AProcess.Options := AProcess.Options + [poWaitOnExit];
  Result :=  0;
  Try
      AProcess.Execute;
  except
    On E :Exception do begin
      Result := 2;
    end;
  end;
  AProcess.Free;
end;

procedure TForm1.BatchButtonClick(Sender: TObject);
var
  SpiceFehler: Integer;
  InputL: TStringList;

begin
   try
      if not FileExists(CirStartFile) then
         raise EInOutError.Create('no file')
   except
      MessageDlg('file ' + CirStartFile + ' not found', mtError,
      [mbAbort], 0);
      exit;
   end;
     InputL := TStringList.Create;
     ComboBox1.Text := CirStartFile ;
     UpdateComboBox1;
     StartIni.WriteString('LastInputFile', 'File', CirStartFile);
     StartIni.UpdateFile;

     AusFileName := ExtractFileName(CirStartFile);
     CirPath := ExtractFilePath(CirStartFile);
     // .cir entfernen
     Delete(AusFileName, Pos(ExtractFileExt(CirStartFile),AusFileName), 10);

     // Eingabe für DuSpice vorbereiten
     // z. B. spice3 /spice/examples/adder.cir -b -r testadder.out -o testadder.log
     if (instatus1 = 0) then
     begin
       InputL.Add(CirStartFile);
       InputL.Add('-b');
       InputL.Add('-r');
       InputL.Add(CirPath + AusFileName + '.out');
     end
     else
     begin
       InputL.Add(CirStartFile);
       InputL.Add('-b');
     end;

     InputL.Add('-o');
     InputL.Add(CirPath + AusFileName + '.log');

     // SPICE3 im Batchmodus starten
     SpiceFehler := ExecFile2(SpiceStartFile, ExtractFilePath(SpiceStartFile), InputL);
     InputL.Free;
    if (SpiceFehler = 2) then
      begin
      MessageDlg('DuSpice.exe not found !' + #13 + 'Please correct DuSpiceStart.ini !',
        mtError, [mbAbort], 0);
      application.terminate;
      end;
end;

procedure TForm1.log1Click(Sender: TObject);
begin

end;

procedure TForm1.LogButtonClick(Sender: TObject);
var
   epath: string;
begin
   AusFileName := ExtractFileName(CirStartFile);
   // .cir entfernen
   Delete(AusFileName, Pos(ExtractFileExt(CirStartFile),AusFileName), 10);
   if not FileExists(CirPath + AusFileName + '.log') then
   begin
      epath := ExtractFilePath(SpiceStartFile);
   // search in the executable's path
      if not FileExists(epath + '\' + AusFileName + '.log') then
      begin
         MessageDlg('File ' + AusFileName + '.log not found', mtError,
         [mbAbort], 0);
         exit;
      end
      else
      begin
         ExecFile(ViewerStartFile, epath + AusFileName + '.log', Startpath, SW_SHOW);
         exit;
      end;
   end;
   ExecFile(ViewerStartFile, CirPath + AusFileName + '.log', Startpath, SW_SHOW);
end;

procedure TForm1.UpdateComboBox1;
var
   icount, ii, ib: Integer;
begin
     icount := ComboBox1.Items.Count;
     ib := 0;
     // Compare items
     for ii := 0  to icount - 1 do
     begin
       if ComboBox1.Items.Strings[ii] = CirStartFile then
       begin
          ib := 1;
          break;
       end;
     end;
     if ib = 0  then
     begin
        if (icount = 5) then
           ComboBox1.Items.Delete(0);
        ComboBox1.Items.Add(CirStartFile);
        // Update InputFiles section of ini file
        StartIni.EraseSection('InputFiles');
        icount := ComboBox1.Items.Count;
        for ii := 0  to icount - 1 do
        begin
          StartIni.WriteString('InputFiles', 'File' + IntToStr(ii), ComboBox1.Items.Strings[ii]);
          StartIni.UpdateFile;
        end;
     end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
   CirStartFile := ComboBox1.Text;
   CirPath := ExtractFilePath(CirStartFile);
end;

procedure TForm1.ComboBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if(Key = VK_RETURN) Then
   begin
     CirStartFile := ComboBox1.Text;
     CirPath := ExtractFilePath(CirStartFile);
     UpdateComboBox1;
   end;
end;

procedure TForm1.NeuDatButtonClick(Sender: TObject);
begin
   try
      // falls direct über SPICE_Start.exe gestartet und noch kein Eintrag im *.ini-File
      if (CirStartFile = '') then
         OpenDialog1.InitialDir := ExtractFilePath(ParamStr(0))
      //vorheriges Verzeichnis anwählen
      else
         OpenDialog1.InitialDir := ExtractFilePath(CirStartFile);
{ OpenDialog1.InitialDir := Startpath;  //im Verzeichnis der Anwendung suchen}
      //  z.B. C:\Spice_be\examples
      OpenDialog1.Title := 'Start ' + SpiceName + ' with new input file' ;
      OpenDialog1.Filter := SpiceName + ' input (*.cir, *.sp)|*.cir; *.sp; *.net|all (*.*)|*.*' ;
      if OpenDialog1.Execute then           {File-Dialogbox öffnen}
      begin
         CirStartFile := OpenDialog1.FileName;      {gewähltes File einlesen, incl. Pfad}
         // z.B. C:\SPICE_BE\input\NMOS.ein
         //Test, ob file existiert, falls nicht, Exception
         if not FileExists(CirStartFile) then
            raise EInOutError.Create('no file')
         else
         // instatus3: 0: do not start automaticaly 1: start batch mode
//            2: start interactive mode
         begin
           if (instatus3 = 1) then
           begin
              CirPath := ExtractFilePath(CirStartFile);
//            if CheckBox4.Checked then
               BatchButtonClick(Sender)  // SPICE wird im Batch-Modus gestartet  end
            end
            else if (instatus3 = 2) then
            begin
               CirPath := ExtractFilePath(CirStartFile);
               Interaktiv_ButtonClick(Sender);
            end;
         end;

         ComboBox1.Text := CirStartFile ;
      end;
   except
      MessageDlg('file ' + CirStartFile + ' not found', mtError,
      [mbAbort], 0);
      exit;
   end;
end;

procedure TForm1.AusButtonClick(Sender: TObject);
begin
   AusFileName := ExtractFileName(CirStartFile);
   // .cir entfernen
   Delete(AusFileName, Pos(ExtractFileExt(CirStartFile),AusFileName), 10);
   if not FileExists(CirPath + AusFileName + '.out') then
   begin
      MessageDlg('File ' + AusFileName + '.out not found', mtError,
      [mbAbort], 0);
      exit;
   end;
   ExecFile(ViewerStartFile ,CirPath + AusFileName + '.out', Startpath, SW_SHOW);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   StartIni.UpdateFile();
   StartIni.Free;
end;

procedure TForm1.EditButtonClick(Sender: TObject);
begin
  OpenDialog1.InitialDir := Startpath + '\examples';  //im Unterverzeichnis \examples suchen
//  z.B. C:\SPICE_BE\examples
  OpenDialog1.Title := 'Edit input file for ' + SpiceName;
  OpenDialog1.FileName := CirStartFile;

  if OpenDialog1.Execute then           {File-Dialogbox öffnen}
  begin
     EditFile := OpenDialog1.FileName;      {gewähltes File einlesen, incl. Pfad}
// z.B. C:\SPICE_BE\examples\mosmem.cir
     ExecFile(EditStartFile, EditFile, '', SW_SHOW);
  end
end;

procedure TForm1.out1Click(Sender: TObject);
begin

end;

procedure TForm1.PlotButtonClick(Sender: TObject);
// Plotten mit  DuSpice
var
   PlotStartFile: String;

begin

   if AusFileName = '' then
   begin
      AusFileName := ExtractFileName(CirStartFile);
      // .cir entfernen
      Delete(AusFileName, Pos(ExtractFileExt(CirStartFile),AusFileName), 10);
   end;
   PlotStartFile :=  CirPath + AusFileName + '.out';

   if ExecFile('DuSpicePlot.exe',PlotStartFile, StartPath, SW_SHOW) = 2 then
     begin
     MessageDlg('DuSpicePlot.exe not found!' + #13 + #13 + 'Please copy file to '
     + #13 + StartPath, mtWarning, [mbOk], 0);
     exit;
     end;
end;

procedure TForm1.Setup1Click(Sender: TObject);
begin
    Setup.Form2.Show;
end;

procedure TForm1.StartBSPICE1Click(Sender: TObject);
begin
   BatchButtonClick(Sender);
end;

procedure TForm1.neueDatei1Click(Sender: TObject);
begin
   NeuDatButtonClick(Sender);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
   Ueber.AboutBox.ShowModal;
end;

procedure TForm1.Ende1Click(Sender: TObject);
begin
   Form1.Close;
end;

procedure TForm1.Hilfe1Click(Sender: TObject);
begin
   {HilfeFenster 1 (hier: Allgemeines) aufrufen}
   Application.HelpCommand(HELP_CONTEXT, 1);
end;

procedure TForm1.DebugButtonClick(Sender: TObject);
var
   epath: string;
begin
   epath := ExtractFilePath(SpiceStartFile);
   if not FileExists(epath + 'debug-out.txt') then
   begin
   // search in the executable's path
      if not FileExists(CirPath + 'debug-out.txt') then
      begin
         MessageDlg('File debug-out.txt not found', mtError,
         [mbAbort], 0);
         exit;
      end
      else
      begin
         ExecFile(ViewerStartFile, CirPath + 'debug-out.txt', Startpath, SW_SHOW);
         exit;
      end;
   end;
   ExecFile(ViewerStartFile, epath + 'debug-out.txt', Startpath, SW_SHOW);
end;

procedure TForm1.QuitButtonClick(Sender: TObject);
begin
   Form1.Close;
end;

procedure TForm1.Interaktiv_ButtonClick(Sender: TObject);
//Start von DuSpice.exe
var
   IntSPICE_EIN: TStringList;
   SpiceFehler: Integer;

begin
   try
      if not FileExists(CirStartFile) then
         raise EInOutError.Create('no file')
   except
      MessageDlg('file ' + CirStartFile + ' not found', mtError,
      [mbAbort], 0);
      exit;
   end;

   IntSPICE_EIN := TStringList.Create;
   AusFileName := ExtractFileName(CirStartFile);
   // .cir entfernen
   Delete(AusFileName, Pos(ExtractFileExt(CirStartFile),AusFileName), 10);

   // Eingabe für DuSpice vorbereiten
   // z. B. spice3 "/spice/examples/adder.cir"
   if (instatus4 = 0) then
      IntSPICE_Ein.Add(CirStartFile)
   else
   begin
      IntSPICE_Ein.Add('-o');
      IntSPICE_Ein.Add(AusFileName + '.log');
      IntSPICE_Ein.Add(CirStartFile);
   end;

   StartIni.WriteString('LastInputFile', 'File', CirStartFile);
   StartIni.UpdateFile;

   ComboBox1.Text := CirStartFile;
   UpdateComboBox1;

   SpiceFehler := ExecFile2(SpiceStartFile, ExtractFilePath(SpiceStartFile), IntSPICE_EIN);

   IntSPICE_EIN.Destroy;

   if SpiceFehler = 2 then
   begin
      MessageDlg(SpiceStartFile + ' not processed correctly!',
      mtError, [mbAbort], 0);
      application.terminate;
   end;
end;

procedure TForm1.StartInteraktiv1Click(Sender: TObject);
begin
  Interaktiv_Button.Click;
end;

procedure TForm1.UIF(Sender: TObject);
begin
    OpenDialog1.Title := 'Edit user defined initialization file';
    OpenDialog1.FileName := SpiceUIFName;

    if OpenDialog1.Execute then           {File-Dialogbox öffnen}
    begin
       EditFile := OpenDialog1.FileName;      {gewähltes File einlesen, incl. Pfad}
  // z.B. C:\SPICE_BE\examples\mosmem.cir
       ExecFile(EditStartFile, EditFile, '', SW_SHOW);
    end
end;

// re-initialize upon closure of Setup window
// instatus1: 0: with rawfile              1: w/o rawfile
// instatus2: 0: ngspice                   1: DuSpice
// instatus3: 0: do not start automaticaly 1: start batch mode
//            2: start interactive mode
// instatus4: 0: no log file in interactive mode 1: with log file
procedure TForm1.UpdateStrings;
var
  spice_ok: Boolean;

begin
  spice_ok := false; //DuSpice.exe not available
  if (instatus2 = 1) then
  begin
     SpiceExName := 'DuSpice.exe';
     SpiceName := 'DuSpice';
     //Pfad für DuSpice festlegen, aus .ini-Datei lesen
     SpiceStartFile := StartIni.ReadString('DuSpiceExec', 'File', '');
  end
  else
  begin
     SpiceExName := 'ngspice.exe';
     SpiceName := 'ngspice';
     //Pfad für ngpice festlegen, aus .ini-Datei lesen
     SpiceStartFile := StartIni.ReadString('ngspiceExec', 'File', '');
  end;
// check if entry to SpiceStart.ini is a file and is DuSpice.exe or ngspice.exe
  if SpiceStartFile <> '' then
  begin
     spice_ok := FileExists(SpiceStartFile) {AND (ExtractFileName(SpiceStartFile) = SpiceExName)}
  end;

  If not spice_ok then
  // kein ini-File: erst DuSpice.exe im Pfad von spice_start suchen,
  // falls erfolglos, direkt den Eingabedialog aufrufen
     begin
        OpenDialog2.Title := 'Search for ' + SpiceExName;
        OpenDialog2.FileName := SpiceExName;
        OpenDialog2.InitialDir := Startpath ;
        if FileExists(Startpath + SpiceExName) then
           begin
           SpiceStartfile := Startpath + SpiceExName;
           end
          else if OpenDialog2.Execute then           {File-Dialogbox öffnen}
           begin
              SpiceStartfile := OpenDialog2.FileName;      {gewähltes File einlesen}
           end
        else
           begin
           application.terminate;
           end;
        if (instatus2 = 0) then
        {if (SpiceExName = 'ngspice.exe') then }
           StartIni.WriteString('ngspiceExec', 'File', SpiceStartfile)
        else
           StartIni.WriteString('DuSpiceExec', 'File', SpiceStartfile);
        StartIni.UpdateFile;
     end;
  if (instatus4 = 0) then
     Interaktiv_Button.hint := 'start ' + SpiceName + ' in interactive mode'
  else
     Interaktiv_Button.hint := 'start ' + SpiceName +
     ' in interactive mode with log-file';
  if (instatus1 = 0) then
     BatchButton.hint := 'start ' + SpiceName + ' in batch mode with rawfile'
  else
     BatchButton.hint := 'start ' + SpiceName + ' in batch mode w/o rawfile';
  if (instatus1 = 0) then
     NeuDatButton.Hint := 'select new input file, do not start'
  else if (instatus1 = 1) then
     NeuDatButton.Hint := 'select new input file and start batch mode'
  else
     NeuDatButton.Hint := 'select new input file and start interactive mode';
end;


procedure TForm1.TitleButtonClick(Sender: TObject);
var
  titletext: string;
  infile: TextFile;

begin
   try
      if not FileExists(CirStartFile) then
         raise EInOutError.Create('no file')
   except
      MessageDlg('file ' + CirStartFile + ' not found', mtError,
      [mbAbort], 0);
      exit;
   end;
     AssignFile(infile, CirStartFile);
     Reset(infile);
     Readln(infile, titletext);
     CloseFile(infile);
     ShowMessage(titletext);

end;

procedure TForm1.VersionButtonClick(Sender: TObject);
begin
//    ShowMessage(SpiceStartFile);
    Setup.Form2.Show;
end;

end.
