unit Setup;

{Copyright (c) 2021, Holger Vogt
All rights reserved.

License: 2-Clause BSD (see start.pas)}

{$MODE Delphi}

interface

uses
  LCLIntf, LCLType, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type

  { TForm2 }

  TForm2 = class(TForm)
    Edit2: TEdit;
    Label2: TLabel;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    Edit1: TEdit;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    Button3: TButton;
    RadioGroup4: TRadioGroup;
    procedure Edit1Change(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit2DblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure RadioGroup4Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form2: TForm2;

implementation

uses
  START;
{$R *.lfm}


procedure TForm2.Button1Click(Sender: TObject);
begin
   Form2.Close;
end;

procedure TForm2.Button2Click(Sender: TObject);
var
   editfile: string;
begin
   // select an editor
   OpenDialog1.Title := 'Search for an editor';
   OpenDialog1.FileName := 'notepad++.exe';
   OpenDialog1.InitialDir := 'C:\Program Files (x86)';
   if OpenDialog1.Execute then           {File-Dialogbox öffnen}
   begin
      editfile := OpenDialog1.FileName;      {gewähltes File einlesen}
      Start.StartIni.WriteString('EditExec', 'Editor', editfile)
   end;
end;

procedure TForm2.Button3Click(Sender: TObject);
var
   viewerfile: string;
begin
   // select an editor
   OpenDialog1.Title := 'Search for a viewer';
   OpenDialog1.FileName := 'notepad++.exe';
   OpenDialog1.InitialDir := 'C:\Program Files (x86)';
   if OpenDialog1.Execute then           {File-Dialogbox öffnen}
   begin
      viewerfile := OpenDialog1.FileName;      {gewähltes File einlesen}
      Start.StartIni.WriteString('ViewerExec', 'Viewer', viewerfile)
   end;
end;

procedure TForm2.Edit1Click(Sender: TObject);
begin
   OpenDialog1.Title := 'Search for ' + SpiceExName;
   OpenDialog1.FileName := SpiceExName;
   OpenDialog1.InitialDir := ExtractFilePath(Edit1.Text); { 'C:\Spice\bin'};
   if OpenDialog1.Execute then           {File-Dialogbox öffnen}
   begin
      SpiceStartfile := OpenDialog1.FileName;      {gewähltes File einlesen}
      if (instatus2 = 0) then
   {   if (SpiceExName = 'ngspice.exe') then }
         Start.StartIni.WriteString('ngspiceExec', 'File', SpiceStartfile)
      else
         Start.StartIni.WriteString('DuSpiceExec', 'File', SpiceStartfile);
      Start.Form1.UpdateStrings;
      Label1.Caption := 'Path to ' + SpiceName + ' executable';
      Edit1.Text := SpiceStartFile;
   end;
end;

procedure TForm2.Edit1Change(Sender: TObject);
begin

end;


procedure TForm2.Edit2Change(Sender: TObject);
begin

end;

procedure TForm2.Edit2DblClick(Sender: TObject);
begin
   OpenDialog1.Title := 'Search for User defined initilazation file';
   OpenDialog1.FileName := '.spiceinit';
   OpenDialog1.Filter := '';
   OpenDialog1.InitialDir := ExtractFilePath(Edit2.Text); { 'C:\Spice\bin'};
   if OpenDialog1.Execute then           {File-Dialogbox öffnen}
   begin
      SpiceUIFName := OpenDialog1.FileName;      {gewähltes File einlesen}
      Start.StartIni.WriteString('ngspiceUIF', 'File', SpiceUIFName);
      Start.Form1.UpdateStrings;
      Label2.Caption := 'Path to user defined initialization file';
      Edit2.Text := SpiceUIFName;
   end;
end;

procedure TForm2.FormHide(Sender: TObject);
begin
   Start.StartIni.WriteString('Radiogroups', '1', IntToStr(instatus1));
   Start.StartIni.WriteString('Radiogroups', '2', IntToStr(instatus2));
   Start.StartIni.WriteString('Radiogroups', '3', IntToStr(instatus3));
   Start.StartIni.WriteString('Radiogroups', '4', IntToStr(instatus4));
end;


// instatus1: 0: with rawfile              1: w/o rawfile
// instatus2: 0: ngspice                   1: DuSpice
// instatus3: 0: do not start automaticaly 1: start batch mode
//            2: start interactive mode
procedure TForm2.FormShow(Sender: TObject);
begin
try
   Edit1.Text := SpiceStartFile;
   Edit2.Text := SpiceUIFName;
   instatus1 := StrToInt(StartIni.ReadString('Radiogroups', '1', ''));
   Radiogroup1.Itemindex := instatus1;
   instatus2 := StrToInt(Start.StartIni.ReadString('Radiogroups', '2', ''));
   Radiogroup2.Itemindex := instatus2;
   instatus3 := StrToInt(Start.StartIni.ReadString('Radiogroups', '3', ''));
   Radiogroup3.Itemindex := instatus3;
   instatus4 := StrToInt(Start.StartIni.ReadString('Radiogroups', '4', ''));
   Radiogroup4.Itemindex := instatus4;
except
   Radiogroup1.Itemindex := 0;
   instatus1 := 0;
   Radiogroup2.Itemindex := 0;
   instatus2 := 0;
   Radiogroup3.Itemindex := 0;
   instatus3 := 0;
   Radiogroup4.Itemindex := 0;
   instatus4 := 0;
end;
   Start.Form1.UpdateStrings;
   Label1.Caption := 'Path to ' + SpiceName + ' executable';
   Edit1.Text := SpiceStartFile;
end;

procedure TForm2.RadioGroup1Click(Sender: TObject);
begin
   instatus1 := Radiogroup1.Itemindex;
end;

procedure TForm2.RadioGroup2Click(Sender: TObject);
begin
   instatus2 := Radiogroup2.Itemindex;
   Start.Form1.UpdateStrings;
   Label1.Caption := 'Path to ' + SpiceName + ' executable';
   Edit1.Text := SpiceStartFile;
end;

procedure TForm2.RadioGroup3Click(Sender: TObject);
begin
   instatus3 := Radiogroup3.Itemindex;
end;

procedure TForm2.RadioGroup4Click(Sender: TObject);
begin
   instatus4 := Radiogroup4.Itemindex;
end;

end.


