*Digital inverter
.PARAM V_SUPPLY = '2.000000E+000'
.PARAM INP_FREQ = '8.500000E+008'
.PARAM INP_PERIOD = '1/INP_FREQ'
.PARAM NO_PERIODS = '4'
.PARAM TMEAS_START = '(NO_PERIODS-1)*INP_PERIOD'
.PARAM TMEAS_STOP = '(NO_PERIODS)*INP_PERIOD'
.PARAM TMEAS_1 = 'TMEAS_STOP -3*INP_PERIOD/4'
.PARAM TMEAS_2 = 'TMEAS_STOP -1*INP_PERIOD/4'
VDD VDD 0 V_SUPPLY
VSS VSS 0 0
VSIG IN VSS PULSE V_SUPPLY 0 'INP_PERIOD/2' 'INP_PERIOD/1000'
+               'INP_PERIOD/1000' 'INP_PERIOD/2' 'INP_PERIOD'
MP OUT IN VDD VDD PMOS W='7.963063E-003'   L=3.500000E-007
MN OUT IN VSS VSS NMOS W='7.963063E-003/3' L=3.500000E-007
CL OUT VSS 10p
.TRAN 'INP_PERIOD/1000' 'NO_PERIODS*INP_PERIOD' SWEEP MONTE=2
.PROBE TRAN V(IN)
.PROBE TRAN V(OUT)
.OPTION POST PROBE ACCURATE
.INCLUDE p.typ
.INCLUDE n.typ
.measure tran ZP_SUPPLY0 rms par('i(vdd)*v_supply') from=tmeas_start to=tmeas_stop
.measure tran ZVHIGH1 find v(OUT) at='TMEAS_2'
.measure tran ZVLOW2 find v(OUT) at='TMEAS_1'
.end
