*Chebyshev Band Pass Filter

*** *** FILTER CIRCUIT *** ***
C1 1 0 #C1#  $ #CSMD_50p80p#
L1 1 0 #L1#  $ #LBOND_350p450p#

L2 1 2 #L2#  $ #LBOND_60n100n#
C2 2 3 #C2#  $ #CSMD_300f340f#

C3 3 0 #C3#  $ #CSMD_50p80p#
L3 3 0 #L3#  $ #LBOND_350p450p#

*C1 1 0 5.787312E-011  ; #CSMD_50p80p#
*L1 1 0 4.407922E-010  ; #LBOND_350p450p#
*L2 1 2 8.341343E-008  ; #LBOND_60n100n#
*C2 2 3 3.054929E-013  ; #CSMD_300f340f#
*C3 3 0 5.661559E-011  ; #CSMD_50p80p#
*L3 3 0 4.496778E-010  ; #LBOND_350p450p#

*** ***      *** ***
*VIN IN 0 ac 1
RG  IN 1 1n


*** s parameter measurement ***
*** Driver and readout
XSP in 3 S22 S12 S_PARAM

.param Rbase=50 Vbias_in=0 Vbias_out=0

.SUBCKT S_PARAM 22 66 5 7
* Resistors emulate switches with Ron=0.001 and Roff=1e12
* to switch driver to input and readout to output (and vice versa, see below)
* switched off not to disturb the circuit, if other measurements are due
RS1 22 2 1e12
RS2 66 6 1e12
RS3 22 6 1e12
RS4 66 2 1e12
*Driver
Vacdc 1 0 DC 'Vbias_in' AC 1 $ ac voltage and dc bias at input (applied through load resistor)
R1 1 2 'Rbase'
E1 3 0 2 0 2       $ amplify in port ac voltage by 2
Vac 3 4 DC 0 AC 1  $ subtract driving ac voltage
R_loop 4 5 0.001
R3 5 0 1           $ ground return for measure node 5
*Readout
E2 7 0 6 0 2       $ amplify out port ac voltage by 2
R4 6 8 'Rbase'     $ load resistor at output (ac)
Vdc 8 0 DC 'Vbias_out' AC 0 $ dc bias at output (applied through load resistor)
.ends



*** *** ANALYSIS *** ***
.AC DEC 1000 800e6 1200E6
*.NET v(3) VIN rout=50 rin=50
*.SAVE s11(VIN) s21(vin)
*.OPTION POST PROBE

.control
set noaskquit
set filetype=ascii

* nodes 22 and 66 are still quasi open
*switch input and output
alter R.XSP.RS1=0.001
alter R.XSP.RS2=0.001
alter R.XSP.RS3=1e12
alter R.XSP.RS4=1e12
* measurement for s11 and s21
run
* switch input and output
alter R.XSP.RS1=1e12
alter R.XSP.RS2=1e12
alter R.XSP.RS3=0.001
alter R.XSP.RS4=0.001
* measurement for s12 and s22
run
let s11=ac1.s22
let s21=ac1.s12
settype s-param S11 S21 S22 S12
 
let S11db = db(s11)
let S12db = db(s12)
let S21db = db(s21)
let S22db = db(s22)
settype decibel S11db S21db S22db S12db

*MEAS ac ZLeft_Side_Lobe0 max S21 from=800e6 to=900e6
*MEAS AC ZPass_Band_Ripple1 min S21 from=960e6 to=1040e6
*MEAS AC ZRight_Side_Lobe2 max S21 from=1100e6 to=1200e6
*MEAS AC S11_In_Band MAX S11 from=960e6 to=1040e6

.endc

.END
