*Digital inverter

.PARAM V_SUPPLY = '#V_SUPPLY#'
.PARAM INP_FREQ = '#INP_FREQ#'
.PARAM INP_PERIOD = '1/INP_FREQ'
.PARAM NO_PERIODS = '4'
.PARAM TMEAS_START = '(NO_PERIODS-1)*INP_PERIOD'
.PARAM TMEAS_STOP = '(NO_PERIODS)*INP_PERIOD'
.PARAM TMEAS_1 = 'TMEAS_STOP -3*INP_PERIOD/4'
.PARAM TMEAS_2 = 'TMEAS_STOP -1*INP_PERIOD/4'

*** *** SUPPLY VOLTAGES *** ***
VDD VDD 0 {V_SUPPLY}
VSS VSS 0 0

*** *** INPUT SIGNAL *** ***
VSIG IN VSS DC 0 PULSE {V_SUPPLY} 0 'INP_PERIOD/2' 'INP_PERIOD/1000'
+               'INP_PERIOD/1000' 'INP_PERIOD/2' 'INP_PERIOD'

*** *** CIRCUIT *** ***
MP OUT IN VDD VDD PM W='#WP#'   L=#LMIN# pd='2*#WP#' ps='2*#WP#'
MN OUT IN VSS VSS NM W='#WP#/3' L=#LMIN# pd='2/3*#WP#' ps='2/3*#WP#'

CL OUT VSS 1p

*** *** ANALYSIS *** ***
.TRAN 'INP_PERIOD/1000' 'NO_PERIODS*INP_PERIOD'
*
*.PROBE TRAN V(IN)  ; .MEASURE fails if line is not commented
*.PROBE TRAN V(OUT) ; .MEASURE fails if line is not commented
.OPTION noacct
.include b3.typ
.control
run
.endc
.END
